<?php

/**
 * EXHIBIT A. Common Public Attribution License Version 1.0
 * The contents of this file are subject to the Common Public Attribution License Version 1.0 (the “License”);
 * you may not use this file except in compliance with the License. You may obtain a copy of the License at
 * http://www.oxwall.org/license. The License is based on the Mozilla Public License Version 1.1
 * but Sections 14 and 15 have been added to cover use of software over a computer network and provide for
 * limited attribution for the Original Developer. In addition, Exhibit A has been modified to be consistent
 * with Exhibit B. Software distributed under the License is distributed on an “AS IS” basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the specific language
 * governing rights and limitations under the License. The Original Code is Oxwall software.
 * The Initial Developer of the Original Code is Oxwall Foundation (http://www.oxwall.org/foundation).
 * All portions of the code written by Oxwall Foundation are Copyright (c) 2011. All Rights Reserved.

 * EXHIBIT B. Attribution Information
 * Attribution Copyright Notice: Copyright 2011 Oxwall Foundation. All rights reserved.
 * Attribution Phrase (not exceeding 10 words): Powered by Oxwall community software
 * Attribution URL: http://www.oxwall.org/
 * Graphic Image as provided in the Covered Code.
 * Display of Attribution Information is required in Larger Works which are defined in the CPAL as a work
 * which combines Covered Code or portions thereof with code not governed by the terms of the CPAL.
 */

/**
 * @author Podyachev Evgeny <joker.OW2@gmail.com>
 * @package ow_system_plugins.base.components
 * @since 1.7.1
 */
class BIRTHDAYS_CMP_AvatarUserList extends BASE_CMP_AvatarUserList
{
    protected $key;
    
    public function __construct( array $idList = array(), $key )
    {
        parent::__construct($idList);
        $this->key = $key;

        $this->setTemplate(OW::getPluginManager()->getPlugin('base')->getCmpViewDir().'avatar_user_list.html');
    }
    
    public function onBeforeRender()
    {
        $this->customCssClass .= 'birthdays_avatar_list';
        
        parent::onBeforeRender();
    }
    
    public function getAvatarInfo( $idList )
    {
        $data = parent::getAvatarInfo($idList);
        
        $birthdays = BOL_QuestionService::getInstance()->getQuestionData($idList, array('birthdate'));
        
        foreach ( $data as $userId => $item )
        {
            $yearOld = '';
            
            if ( !empty($birthdays[$userId]['birthdate']) )
            {
                
                switch ( $this->key )
                {
                    case 'birthdays_today':
                        
                        $date = UTIL_DateTime::parseDate($birthdays[$userId]['birthdate'], UTIL_DateTime::MYSQL_DATETIME_DATE_FORMAT);
                        $yearOld =  UTIL_DateTime::getAge($date['year'], $date['month'], $date['day']) . " " . OW::getLanguage()->text('base', 'questions_age_year_old');
                        
                    break;
                
                    case 'birthdays_this_week':    
                        
                        $date = UTIL_DateTime::parseDate($birthdays[$userId]['birthdate'], UTIL_DateTime::MYSQL_DATETIME_DATE_FORMAT);
                        $yearOld =  OW::getLanguage()->text('birthdays', 'birthday') . ' '. UTIL_DateTime::formatBirthdate($date['year'], $date['month'], $date['day']) . " ";
                        
                    break;
                }
            }
            
            if ( !empty($data[$userId]['title']) )
            {
                $data[$userId]['attrs'] = ' data-birthday="' . ((!empty($yearOld)) ? $yearOld : '') . '"';
            }
            else if( !empty($yearOld) )
            {
                $data[$userId]['attrs'] =  ' data-birthday="' . $yearOld . '"';
            }
        }
        
        OW::getDocument()->addOnloadScript("
                $('*[title]', $('.birthdays_avatar_list') ).each( function(i, o){
                    $(o).off('mouseenter');
                    $(o).on('mouseenter', function(){ 
                        var title = $(this).attr('title');
                        var birthday = $(this).data('birthday');
                        
                        if ( !birthday )
                        {
                            OW.showTip($(this), {timeout:200});
                        }
                        else if ( !title && birthday )
                        {
                            birthday = '<span class=\"ow_small\" style=\"font-weight:normal;\">' + birthday + '</span>';
                            
                            OW.showTip($(this), {timeout:200, show:birthday});
                        }
                        else
                        {
                            birthday = '<br><span class=\"ow_small\" style=\"font-weight:normal;\">' + birthday + '</span>';
                            
                            OW.showTip($(this), {timeout:200, show:title + birthday});
                        }
                     });
                    $(o).off('mouseleave');
                    $(o).on('mouseleave', function(){ OW.hideTip($(this)); });
            });" );
        
        return $data;
    }
}